﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Workflow.Runtime;
using System.Workflow.Runtime.Hosting;
using System.Workflow.Activities;








/*  ListenActivity
    
    ListenActivity blocks the execution of the workflow and starts waiting until one of the events it 
    contains to be triggered.
 
    This sample uses the WorkflowRuntime.WorkflowIdled event in order to trigger one of the events
    the ListenActivity listens for.
 */
namespace Lessons.Workflows
{
    class Program
    {
        static void Main(string[] args)
        {

            using (WorkflowRuntime workflowRuntime = new WorkflowRuntime())
            {
                AutoResetEvent waitHandle = new AutoResetEvent(false);
                EventContainer eventContainer = new EventContainer();

                workflowRuntime.WorkflowCompleted += delegate(object sender, WorkflowCompletedEventArgs e) 
                {                     
                    waitHandle.Set();                 
                };

                workflowRuntime.WorkflowTerminated += delegate(object sender, WorkflowTerminatedEventArgs e)
                {
                    Console.WriteLine(e.Exception.Message);
                    waitHandle.Set();
                };

                workflowRuntime.WorkflowIdled += delegate(object sender, WorkflowEventArgs e)
                {
                    Random random = new Random();
                    eventContainer.ProcessNumber(e.WorkflowInstance.InstanceId, random.Next(1, 20));                    
                };

 
                ExternalDataExchangeService ExchangeService = new ExternalDataExchangeService();
                workflowRuntime.AddService(ExchangeService);
                ExchangeService.AddService(eventContainer);

                WorkflowInstance instance = workflowRuntime.CreateWorkflow(typeof(Lessons.Workflows.Workflow1));
                instance.Start();

                waitHandle.WaitOne();

                Console.WriteLine("Hit <ENTER> key to exit");
                Console.ReadLine();
            }
        }
    }
}





namespace Lessons.Workflows
{
    /* an ExternalDataEventArgs descendant class used by an external event.  
       The instanceID of type Guid is used by the WWF runtime to direct the event
       to the correct workflow instance */
    [Serializable]
    public class EventContainerArgs : ExternalDataEventArgs
    {
        private int data = 0;

        public EventContainerArgs(Guid instanceID, int Data)
            : base(instanceID)
        {
            data = Data;
        }

        public int Data { get { return data; } set { data = value; } }
    }


    /* the interface used as a contract between workflow host and workflow runtime engine  */
    [ExternalDataExchange]
    public interface IEventContainer
    {
        event EventHandler<EventContainerArgs> ProcessOddNumber;
        event EventHandler<EventContainerArgs> ProcessEvenNumber;
    }


    /* a class implementing the contract interface. */ 
    public class EventContainer : IEventContainer
    {
        public void ProcessNumber(Guid InstanceId, int Data)
        {
            EventContainerArgs Args = new EventContainerArgs(InstanceId, Data);

            if (Data % 2 == 0)
                ProcessEvenNumber(null, Args);
            else
                ProcessOddNumber(null, Args);
        }
        public event EventHandler<EventContainerArgs> ProcessOddNumber;
        public event EventHandler<EventContainerArgs> ProcessEvenNumber;

    }

}